;idea taken from http://codepen.io/neilorangepeel/pen/mJoxaJ
;coded by UEZ build 2015-08-20
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)
_GDIPlus_Startup()
Global $i
Global Const $iW = 500, $iH = 700, $sTitle = "GDI+ Ascending Rectangles / fps: "
Global Const $hGUI = GUICreate($sTitle & 0, $iW, $iH)
GUISetState()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, 4)

Global Const $iAmount = 24
Global $aData[$iAmount][13] = [[]], $hEffect, $iFPS = 0

For $i = 0 To UBound($aData) - 1
	$aData[$i][0] = Random(20, $iW / 4, 1)	;size
	$aData[$i][1] = _GDIPlus_BitmapCreateFromScan0($aData[$i][0], $aData[$i][0]) ;hBmp
	$aData[$i][2] = _GDIPlus_ImageGetGraphicsContext($aData[$i][1]) ;hGfx
	_GDIPlus_GraphicsSetPixelOffsetMode($aData[$i][2], 4)
	_GDIPlus_GraphicsSetSmoothingMode($aData[$i][2], 4)
	$aData[$i][3] = Random(0, $iW - $aData[$i][0], 1) ;x pos
	$aData[$i][4] = Random($iH, $iH * 3) ;y pos
	$aData[$i][5] = Random(1, 5) ;vy
	$aData[$i][6] = Random(0x08, 0xA0, 1) * 0x1000000 + Random(0x00000, 0xFFFFFF, 1) ;random color alpha + rgb
	$aData[$i][7] = _GDIPlus_BrushCreateSolid($aData[$i][6]) ;hBrush
	$aData[$i][8] = _GDIPlus_PenCreate(0x20505050, Random(1, Ceiling($aData[$i][0] / 14))) ;hPen
	$aData[$i][9] = Random(-6, 6) ;roation
	$aData[$i][10] = _GDIPlus_MatrixCreate() ;hMatrix
	$aData[$i][11] = Random(-50, 50) ;sin value
	$aData[$i][12] = Random(-2, 2) ;increase value for sin
Next

AdlibRegister("CalcFPS", 1000)

GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")

Anim()
While Sleep(30)
	Anim()
WEnd

Func _Exit()
	AdlibUnRegister("CalcFPS")
	For $i = 0 To UBound($aData) - 1
		_GDIPlus_GraphicsDispose($aData[$i][2])
		_GDIPlus_BitmapDispose($aData[$i][1])
		_GDIPlus_BrushDispose($aData[$i][7])
		_GDIPlus_PenDispose($aData[$i][8])
		_GDIPlus_MatrixDispose($aData[$i][10])
	Next
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc

Func Anim()
	Local $i, $fX, $fY, $fW, $fH
	_GDIPlus_GraphicsClear($hCanvas, 0xFFFAFAFF)
	For $i = 0 To UBound($aData) - 1
		_GDIPlus_GraphicsClear($aData[$i][2], 0x00000000)
		_GDIPlus_MatrixTranslate($aData[$i][10], $aData[$i][0] / 2, $aData[$i][0] / 2)
		_GDIPlus_MatrixRotate($aData[$i][10], $aData[$i][9])
		_GDIPlus_MatrixTranslate($aData[$i][10], -$aData[$i][0] / 2, -$aData[$i][0] / 2)
		_GDIPlus_GraphicsSetTransform($aData[$i][2], $aData[$i][10])
		$fX = $aData[$i][0] / 5
		$fY = $fX
		$fW = $aData[$i][0] - $aData[$i][0] / 2.5
		$fH = $fW
		_GDIPlus_GraphicsFillRect($aData[$i][2], $fX, $fY, $fW, $fH, $aData[$i][7])
		_GDIPlus_GraphicsDrawRect($aData[$i][2], $fX, $fY, $fW, $fH, $aData[$i][8])
		_GDIPlus_GraphicsDrawImageRect($hCanvas, $aData[$i][1], $aData[$i][3] + Sin($aData[$i][11] / 100) * 100, $aData[$i][4], $aData[$i][0], $aData[$i][0])
		$aData[$i][11] += $aData[$i][12]
		$aData[$i][4] -= $aData[$i][5]
		If $aData[$i][4] < -$aData[$i][0] * 2 Then
			_GDIPlus_MatrixDispose($aData[$i][10])
			_GDIPlus_GraphicsDispose($aData[$i][2])
			_GDIPlus_BitmapDispose($aData[$i][1])
			$aData[$i][0] = Random(20, $iW / 4, 1)	;size
			$aData[$i][1] = _GDIPlus_BitmapCreateFromScan0($aData[$i][0], $aData[$i][0]) ;hBmp
			$aData[$i][2] = _GDIPlus_ImageGetGraphicsContext($aData[$i][1]) ;hGfx
			_GDIPlus_GraphicsSetPixelOffsetMode($aData[$i][2], 4)
			_GDIPlus_GraphicsSetSmoothingMode($aData[$i][2], 4)
			$aData[$i][3] = Random(0, $iW - $aData[$i][0], 1) ;x pos
			$aData[$i][4] = $iH
			$aData[$i][5] = Random(1, 5) ;vy
			$aData[$i][6] = Random(0x08, 0xA0, 1) * 0x1000000 + Random(0x00000, 0xFFFFFF, 1) ;random color
			_GDIPlus_BrushSetSolidColor($aData[$i][7], $aData[$i][6])
			$aData[$i][9] = Random(-6, 6) ;roation
			$aData[$i][10] = _GDIPlus_MatrixCreate() ;hMatrix
		EndIf
	Next
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
	$iFPS += 1
EndFunc

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc